<?php
    @session_start();

    set_time_limit(0);

    ini_set('post_max_size', '50M');
    ini_set('upload_max_filesize', '50M');

    header( "Content-type: text/html; charset=utf-8" );
    if (!isset($_SESSION["admin"]["id"])) {
        echo "<script>location.href='index.php';</script>";
    	
    }
    include "config/conf.php";
 ?>
 <!DOCTYPE html>
<html>
<head>
	<title><?php echo $title; ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta charset="utf-8">
	<base href="<?php echo "http://".$_SERVER["HTTP_HOST"].$_SERVER["SCRIPT_NAME"]; ?>" />

	<link href='https://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
	<link href='https://fonts.googleapis.com/css?family=Roboto' rel='stylesheet' type='text/css'>

	<link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="css/sb-admin.css">
	<link rel="stylesheet" type="text/css" href="css/font-awesome.min.css">
	<link rel="stylesheet" type="text/css" href="css/jasny-bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="css/jquery.autocomplete.css">
	<link rel="stylesheet" type="text/css" href="css/wysiwyg-color.css">

	<link rel="stylesheet" type="text/css" href="css/style.css">

    <link href="summernote.css" rel="stylesheet">
   

	<script type="text/javascript" src="js/jquery-1.9.1.min.js"></script>
	<script type="text/javascript" src="js/bootstrap.min.js"></script>
	<script type="text/javascript" src="js/jqBootstrapValidation.js"></script>
	<script type="text/javascript" src="js/bootstrap-inputmask.min.js"></script>
	<script type="text/javascript" src="js/jquery.maskMoney.min.js"></script>
	<script type="text/javascript" src="js/prettify.js"></script>
	<script type="text/javascript" src="js/jquery.colorbox-min.js"></script>

    <script src="js/jquery.complexify.js"></script> 
    <script src="summernote.min.js"></script>

	<link rel="stylesheet" type="text/css" href="colorbox.css">
	<script>
	  $(function () { $("input,select,textarea").not("[type=submit]").jqBootstrapValidation(); } );
	  function esconder ()  {
	  	$("#mask").hide();
	  }
	</script>
	<style type="text/css">
		html, body { height: 100%; }
	</style>
</head>
<body onload="esconder()">
<div id="mask" style="top:0;width:100%;height:100%;background: rgba(0,0,0,0.9);position: fixed;z-index: 10000;padding:20px;box-sizing: border-size">
	<img src="img/loading.gif" alt="Carregando..." title="Carregando...">
	<p style="font-size:2em;color:#fff;"><strong>Aguarde, carregando dados...</strong></p>
</div>
<div class="container">

 <?php

    //print_r ( $_FILES );
    //print_r ( $_POST );

    if ( $_POST ) {

    	$parceiro = $_POST["parceiro_id"];

    	$mes = trim ( $_POST["mes"] );
    	if ( $mes < 10 ) $mes = "0$mes";

    	$name = $mes."_".date("Y");

    	$dir = "../../downloads/".$name;

    	$arq = $dir ."/$mes.zip";

    	//pega extensao
    	$extensao = pathinfo($_FILES["arquivo"]["name"]);
		$extensao = $extensao['extension'];

		//verifica se é ZIP
		if ( $extensao != "zip" ) {

			echo "<script>alert('Arquivo com extensão $extensao. Por favor envie um arquivo ZIP');</script>";
			exit;

		} else if ( !extension_loaded( 'zip' ) ) {

			echo "<script>alert('Nao esta habilitado php_zip.dll, edite seu php.ini');</script>";
			exit;

		} else {

			//criar o diretório
			if ( !is_dir( $dir ) ) {
	    		mkdir ( $dir );
	    	}
	    	$erro = $ok = "";

	    	print_r ( $_FILES );

	    	if ( move_uploaded_file ( $_FILES["arquivo"]["tmp_name"] , $arq ) ) {

	    		//descompactar arquivos
	    		$zip = new ZipArchive;
				$zip->open( $arq);
				if ( $zip->extractTo( $dir."/" ) ) {

					//aviso de descompactação - apagar arquivo
					echo "<div class='alert alert-success'>Arquivo descompactado com sucesso!</div>
					<div id='msg'></div>";
					@unlink( $arq );

					$zip->close();	
					$e = $o = $i = 0;

					//abrir os arquivos da pasta
					if ($handle = opendir("$dir")) {
						//se conseguir abrir os arquivos
						while (false !== ($file = readdir($handle))) {
							$i++;

							$c = strlen($file);

							if ( $c > 6 ) {

					        	//pegar extensao do arquivo
					        	$extensao = pathinfo($file);
								$extensao = $extensao['extension'];

								//separar por _
								$dados = explode("_",$file);

								//contar os dados
								$n = count($dados);
								$tipo = $dados[0];

								//verificar o tipo - array 0
								if ($tipo == "BL") $tipo = "Boleto";
								else if ($tipo == "NF") $tipo = "Nota Fiscal";
								else $tipo = "arquivo";

								if ( $tipo == "Boleto") {

									$empresa = $dados[1];
									$cnpj = $dados[2];
									$mes = $dados[3];

									$mes = explode(".",$mes);
									$mes = $mes[0];

									//transformar o mes em numero

									if ($mes == "JANEIRO") $mes = "01";
									else if ($mes == "FEVEREIRO") $mes = "02";
									else if ($mes == "MARCO") $mes = "03";
									else if ($mes == "ABRIL") $mes = "04";
									else if ($mes == "MAIO") $mes = "05";
									else if ($mes == "JUNHO") $mes = "06";
									else if ($mes == "JULHO") $mes = "07";
									else if ($mes == "AGOSTO") $mes = "08";
									else if ($mes == "SETEMBRO") $mes = "09";
									else if ($mes == "OUTUBRO") $mes = "10";
									else if ($mes == "NOVEMBRO") $mes = "11";
									else $mes = "12";

									//pegar data e mudar nome do arquivo
									$data = date("Y-m-d");
									

									//verificar se existe cliente
									$sql = "select * from cliente where cnpj = ? and parceiro_id = ? limit 1";
									$consulta = $db->prepare($sql);
									$consulta->bindParam(1, $cnpj);
									$consulta->bindParam(2, $parceiro);
									$consulta->execute();
									$dados = $consulta->fetch(PDO::FETCH_OBJ);

									if ( !empty ( $dados->id ) ) {

										$nome = $dados->id."_".md5($cnpj)."_".$mes.date("Y").".".$extensao;
									
										$novo = $name."/".$nome;
										@unlink( $dir."/".$nome );
										rename ( $dir."/".$file , $dir."/".$nome );

										//verifica se o arquivo já esta cadastrado
										$sql2 = "select * from arquivo where arquivo = ? limit 1";
							            $consulta2 = $db->prepare($sql2);
							            $consulta2->bindParam(1,$nome);
										$consulta2->execute();
										$dados2 = $consulta2->fetch(PDO::FETCH_OBJ);

										//se não existe arquivo cadastrado inserir
										if ( empty( $dados2->id ) ) {

											$sql = "insert into arquivo values(NULL,?,?,?,?,?)";
								            $consulta = $db->prepare($sql);
								            $consulta->bindParam(1, $tipo);
								            $consulta->bindParam(2, $dados->id);
								            $consulta->bindParam(3, $data);
								            $consulta->bindParam(4, $novo);
								            $consulta->bindParam(5, $dados->valor);
							            

											if ( $consulta->execute() ) {
												$ok .= "<p class='alert alert-success'>Arquivo $nome enviado com sucesso - $dados->nome </p>";
												$o++;
												
											}
											else {
												$erro .= "<p class='alert alert-danger'>Erro ao gravar $file para $dados->nome ".$consulta->errorInfo()[2]."</p>";
												$e++;
												
											}

										} else {

											//se existe arquivo cadastrado
											$erro .= "<p class='alert alert-warning'>Arquivo $file já registrado $nome para $dados->nome</p>";

										}

									} else {

										$erro .= "<div class='alert alert-danger'>Cliente do arquivo <strong>$file</strong> não encontrado! </div>";

									}

								}

							}



						}

						echo "<p class='alert alert-danger'>$i arquivos<br>$e com erro - $o enviados corretamente</p>";

						?>

<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
  <div class="panel panel-default">
    <div class="panel-heading" role="tab" id="headingOne">
      <h4 class="panel-title">
        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
          Arquivos Importados
        </a>
      </h4>
    </div>
    <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
      <div class="panel-body">
       <?=$ok;?>
      </div>
    </div>
  </div>
  <div class="panel panel-default">
    <div class="panel-heading" role="tab" id="headingTwo">
      <h4 class="panel-title">
        <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
          Arquivos com Erro
        </a>
      </h4>
    </div>
    <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
      <div class="panel-body">
        <?=$erro;?>
      </div>
    </div>
  </div>
</div>

<?php 
					} else {

						echo "<div class='alert alert-danger'>Erro ao ler arquivos da pasta $dir !</div>";

					}

				} else {

					echo "<div class='alert alert-danger'>Erro ao descompactar arquivo!</div>";

				}

	    	} else {

	    		echo "<div class='alert alert-danger'>Erro ao copiar arquivo!</div>";

	    	}

		}

    } else {

    	echo "<div class='alert alert-danger'>Requisição Inválida!</div>";

    }

	