<?php
    @session_start();
    if (!isset($_SESSION["admin"]["id"])) {
        echo "<script>location.href='index.php';</script>";
    }
?>
<h1 class="page-header">
    
    	<div class="row">
    		<div class="col-md-7 col-sm-6">
    			Enviar Aviso
            </div>

    		<div class="col-md-5 col-sm-6">
    			<a href="cadastro/mensagem" class="btn btn-success pull-right"><i class="glyphicon glyphicon-envelope"></i> Cadastrar Aviso</a>
    		</div>
    	</div>
    
</h1>

<div class="container">

<form name="enviar" id="formemail" method="post" target="frame" class="form-inline" action="enviarAviso.php">

    <?php
        $id = $param[2];
        $sql = "select m.*, p.nome, p.assinatura from mensagem m
        inner join parceiro p on (p.id = m.parceiro_id) 
        where m.id = ? limit 1";

        $consulta = $db->prepare($sql);
        $consulta->bindParam(1, $id);
        $consulta->execute();

        $dados = $consulta->fetch(PDO::FETCH_OBJ);

        echo "<div class='well' style='width:85%'><strong>Enviar para parceiro: </strong>$dados->nome<br><br><strong>Assunto:</strong> $dados->assunto<br>
        <strong>Mensagem:</strong><br>$dados->mensagem<br><img src='../downloads/$dados->assinatura' alt='$dados->nome'></div>";
    ?>
    <input type="hidden" name="id" value="<?=$id;?>" required>

<div class="row">
    <div class="col-md-2">
        <label for="boleto">Anexar Boleto?
            <select name="boleto" required class="form-control">
                <option value="N">Não</option>
                <option value="S">Sim</option>
            </select>
        </label>
    </div>
    <div class="col-md-1">
        <label for="mes">Mês<br>
            <select name="mes" required class="form-control">
                <?php
                
                        $m = (int)date("m");
                        $i = 1;
                        while ( $m > $i) {
                            if ( $m < 10 ) $m = "0$m";
                            echo "<option>$m</option>";
                            $m--;

                        }

                ?>

            </select>
        </label>
    </div>
    <div class="col-md-3">

        <label for="teste">Enviar primeiro e-mail de teste?
            <select name="teste" required class="form-control">
                <option value="S">Sim</option>
                <option value="N">Não</option>
            </select>
        </label>

    </div>
    <div class="col-md-5">
        <label for="qtde">Enviar iniciando de:
            <select class="form-control" name="qtde" id="qtde">
                <option value="0">0</option>
                <option value="1">250</option>
                <option value="2">500</option>
                <option value="3">750</option>
                <option value="4">1000</option>
                <option value="5">1250</option>
            </select>
            e-mails para frente
        </label>
    </div>
</div>
<div style="float:left;width:85%">
    <br>
    <br>
    <div class="clearfix"></div>



        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#myModal">Ver quem irá Receber</button>
        <button type="button" class="btn btn-success" onclick="enviarEmail()">Enviar</button>
    


    <div class="clearfix"></div>
    <br><br>

    <div class="text-center" id="enviando" style="padding:20px 0px;margin-left:-100px;display:none;">
        <img src="imgs/load.gif" alt="Enviando" title="Enviando" style="margin: auto">
        Aguarde, enviando mensagens...
    </div>
</div>
</form>

<iframe name="frame" id="frame" class="thumbnail" width="85%" height="600px"></iframe>

<script type="text/javascript">
   
    function enviarEmail() {
        if ( confirm ( "Deseja mesmo enviar os e-mails com os boletos? " ) ) {
            $("#formemail").submit();
            $("#enviando").show();
        }
    }
</script>

</div>
<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Listar e-mails</h4>
      </div>
      <div class="modal-body" style="height: 400px; overflow: auto;">
        <strong>Clientes que receberão a mensagem:</strong><br>

        
                <?php

                    $sql = "select c.id, c.cnpj, c.nome, c.email from cliente c 
                    inner join email_mensagem em on (em.cliente_id = c.id) 
                    where em.email_id = ?
                    order by c.nome";
                    $consulta = $db->prepare($sql);
                    $consulta->bindParam(1, $id);
                    $consulta->execute();

                    echo $c = "<p>".$consulta->rowCount()." clientes : </p>";
                ?>

                <table class="table table-hover table-striped table-bordered" width='100%'>
                    <thead>
                        <tr>
                            <td style="width: 200px !important">CNPJ</td>
                            <td style="width: 500px !important">Nome/Razão Social</td>
                            <td style="width: 400px !important">E-mails</td>
                        </tr>
                    </thead>
                    <tbody>
                <?php
                    while ( $dados = $consulta->fetch(PDO::FETCH_OBJ) ) {

                        $e = str_replace(";", "<br>", $dados->email);

                        echo "<tr><td>$dados->cnpj</td><td>$dados->nome</td><td>$e</td></tr>";

                    }

                ?>
            </tbody>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>