<?php
    @session_start();
    set_time_limit(300000);
    if (!isset($_SESSION["admin"]["id"])) {
        echo "<script>location.href='index.php';</script>";
    }
?>
<h1 class="page-header">
    
    	<div class="row">
    		<div class="col-md-7 col-sm-6">
    			Importar Arquivos
            </div>

    		<div class="col-md-5 col-sm-6">
    			<a href="cadastro/importar" class="btn btn-success pull-right"><i class="glyphicon glyphicon-transfer"></i> Nova Importação</a>
    		</div>
    	</div>
    
</h1>

<div class="alert alert-warning">
    Para exportar em CSV abra a planilha no Excel, vá em Arquivo -> Salvar Como e selecione no Tipo CSV (Separado por Vírgula), conforme demonstra a imagem abaixo:
    <p><img src="images/excel.jpg" alt="Excel" title="Excel" width="100%"></p>
  </div>

  <div class="container">
<?php
    
    if ( $_POST ) {

        $tipo = $_POST["tipo"];

        if ( !isset($_FILES["arquivo"]["name"]) )  {

            echo "<div class='alert alert-danger'>Selecione um arquivo para enviar</div>";

        } else {

            $size = $_FILES["arquivo"]["size"] / 1000;
            $extensao = pathinfo($_FILES["arquivo"]["name"]);
            $extensao = $extensao['extension'];

        }

        $erro1 = $erro2 = $erro3 = $erro4 = $ok = "";
        $i1 = $i2 = $i3 = $i4 = 0;
        

        if ( $size > 2000 ) {

             echo "<div class='alert alert-danger'>O arquivo enviado é muito grande ( $size ). Envie arquivos de até 2 MB</div>";
            
        } else if ($extensao != "csv" ) {

             echo "<div class='alert alert-danger'>O arquivo deve ser CSV. Arquivo enviado: $extensao</div>";

        } else if ( $tipo == "pagamento" ) {

            $handle = fopen($_FILES['arquivo']['tmp_name'], "r");
            $i = 0;
            while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
               //pula primeira linha
               if ( $i > 0) {
                    //pega dados iniciais
                    $codigo     = (int)$data[0];
                    $cnpj       = $data[1];
                    $status     = utf8_encode($data[7]);
                    /*$email      = explode(";",$data[12]);
                    $email      = $email[0];*/

                    $email = $data[12];

                    $razao      = utf8_encode($data[2]);
                    $nf         = $data[5];

                    //documento pode ser cpf ou cnpj
                    if ( strlen($cnpj) > 10 ) $cnpj = str_pad($cnpj, 14, "0", STR_PAD_LEFT);
                    else $cnpj = str_pad($cnpj, 11, "0", STR_PAD_LEFT);

                    //consultor minusculo como no login
                    $consultor  = strtolower($data[4]);
                    if ($consultor == "tati") $consultor = "tatiana";
                    else if ( $consultor == "fabio" ) $consultor = "josiane";
                    else if ( ( $consultor == "raquel" ) or ( $consultor == "sabrina" ) or ( $consultor == "paulo cesar") or ( $consultor == "carlos") or ( $consultor == "empresa" ) ) 
                        $consultor = "jefferson";

                    //quer nota fiscal - padrão nao
                    $nf         = $data[5];
                    if ( empty ( $nf ) ) $nf = "NÃO";

                    //informacao do econtato
                    $econtato   = utf8_encode($data[6]);
                    if ( $econtato == "Pendente de Inforamacao" )
                        $econtato = "INFORMAÇÃO PENDENTE";

                    //verificar se tem data, se tiver, converter
                    if ( !empty ( trim ( $data[8] ) ) ) {

                        $dt = explode( "/", $data[8] );

                        if ( checkdate( $dt[1], $dt[0] ,$dt[2] ) ) {

                            $datacancelamento = $dt[2]."-".$dt[1]."-".$dt[0];

                        }

                    }

                    $responsavel= utf8_encode($data[9]);
                    $cpf        = $data[10];
                    $telefone   = $data[11];

                    //formatar o telefone e deixar todos iguais
                    $telefone = "(" . substr($telefone, 0, 2) . ") " . substr($telefone, 2, 4) . "-" . substr($telefone, 6, 10);
                    
                    $cidade     = utf8_encode($data[13]);
                    $estado     = $data[14];
                    $parceiro   = $data[15];
                    $logon      = $data[18];
                    $valor      = $data[19];
                    $acesso     = $data[20];
                    $observacao = utf8_encode($data[26]. " - ". $data[27]);

                    if ( $parceiro == "SPC") // Serasa
                        $parceiro_id = 2;
                    else // SPC
                        $parceiro_id = 1;

                    //formatar o valor
                    $valor = str_replace( ".", "", $valor );
                    $valor = str_replace( ",", ".", $valor );

                    $valor = floatval( $valor );

                    //selecionar funcionario
                    $sql = "select f.id, f.nome from funcionario f
                        inner join cargo c on (c.id = f.cargo_id)
                        inner join parceiro p on (p.id = c.parceiro_id)
                        where p.id = ".(int)$parceiro_id." AND f.login = '$consultor' limit 1";

                    $consulta = $db->prepare($sql);
                    $consulta->execute();
                    $dados2 = $consulta->fetch(PDO::FETCH_OBJ);

                    if ( empty ( $dados2->id ) ) {

                        $i3++;
                        $erro3 .= "<p class='alert alert-warning'>$i3 - Erro ao encontrar funcionário $consultor para $razao - $parceiro_id</p>";

                    } else {

                        //pegar id do funcionario
                        $funcionario_id = $dados2->id;
                        $senha = md5($cnpj);
                        

                        //verificar se o cliente ja existe com aquele parceiro
                        //se nao existir dá insert, se existir dá update

                        //selecionar cliente para ver se o mesmo existe e dau insert ou update
                        $sql = "select id, nome from cliente where cnpj = ? and parceiro_id = ? limit 1";
                        $consulta = $db->prepare($sql);
                        $consulta->bindParam(1, $cnpj);
                        $consulta->bindParam(2, $parceiro_id);
                        $consulta->execute();
                        $dados = $consulta->fetch(PDO::FETCH_OBJ);
                        
                        if ( empty ( $dados->id ) ) {
                            $ativo = "Sim";

                            //se não existir insert

                            $sql = "insert into cliente values ( NULL , ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

                            $consulta = $db->prepare($sql);
                            $consulta->bindParam(1, $razao);
                            $consulta->bindParam(2, $codigo);
                            $consulta->bindParam(3, $cnpj);
                            $consulta->bindParam(4, $funcionario_id);
                            $consulta->bindParam(5, $econtato);
                            $consulta->bindParam(6, $responsavel);
                            $consulta->bindParam(7, $telefone);
                            $consulta->bindParam(8, $email);
                            $consulta->bindParam(9, $senha);
                            $consulta->bindParam(10, $ativo);
                            $consulta->bindParam(11, $nf);
                            $consulta->bindParam(12, $status);
                            $consulta->bindParam(13, $datacancelamento);
                            $consulta->bindParam(14, $cpf);
                            $consulta->bindParam(15, $cidade);
                            $consulta->bindParam(16, $estado);
                            $consulta->bindParam(17, $parceiro_id);
                            $consulta->bindParam(18, $acesso);
                            $consulta->bindParam(19, $valor);
                            $consulta->bindParam(20, $desconto);
                            $consulta->bindParam(21, $observacao);
                            $consulta->bindParam(22, $logon);

                            if ( $consulta->execute() ) {

                                $ok .= "<p class='alert alert-success'>$razao adicionado com sucesso!</p>";

                            } else {

                                $i1++;
                                $m = explode("'",$consulta->errorInfo()[2]);
                                $campo = $m[1];
                                $campo = $$campo;



                                $erro1 .= "<p class='alert alert-danger'><strong>$i1 - Erro:</strong> erro ao inserir $razao ".$consulta->errorInfo()[2]." ( $campo ) - $data[8]!</p>";
                            } //else do execute

                        } else {
                            //se existir dar update

                            $sql = "update cliente set nome = ?, codigo = ?, funcionario_id = ?,
                            econtato = ?, contato = ?, telefone = ?, email = ?, nf = ?, status = ?, cancelamento = ?, cpf = ?, cidade = ?, estado = ?, acesso = ?, valor = ?, desconto = ?, observacao = ?, logon = ? where id = ? and parceiro_id = ? limit 1";

                            $consulta = $db->prepare($sql);
                            $consulta->bindParam(1, $razao);
                            $consulta->bindParam(2, $codigo);
                            $consulta->bindParam(3, $funcionario_id);
                            $consulta->bindParam(4, $econtato);
                            $consulta->bindParam(5, $responsavel);
                            $consulta->bindParam(6, $telefone);
                            $consulta->bindParam(7, $email);
                            $consulta->bindParam(8, $nf);
                            $consulta->bindParam(9, $status);
                            $consulta->bindParam(10, $datacancelamento);
                            $consulta->bindParam(11, $cpf);
                            $consulta->bindParam(12, $cidade);
                            $consulta->bindParam(13, $estado);
                            $consulta->bindParam(14, $acesso);
                            $consulta->bindParam(15, $valor);
                            $consulta->bindParam(16, $desconto);
                            $consulta->bindParam(17, $observacao);
                            $consulta->bindParam(18, $logon);
                            $consulta->bindParam(19, $dados->id);
                            $consulta->bindParam(20, $parceiro_id);

                            if ( $consulta->execute() ) {

                                $ok .= "<p class='alert alert-success'>$razao alterado com sucesso!</p>";

                            } else {
                                $m = explode("'",$consulta->errorInfo()[2]);
                                $campo = $m[1];
                                $campo = $$campo;

                                $i1++;
                                $erro1 .= "<p class='alert alert-warning'><strong>$i1 - Erro:</strong> erro ao alterar $razao ".$consulta->errorInfo()[2]." ( $campo ) - $data[8]!</p>";
                            } //else do execute
                        }

                        

                    } //else do consultor
                   
               }
               $i++;
                
            }

            echo "<hr><div class='alert alert-info'>Foram importados $i registros</div><br><br>";

            ?>
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
              <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingOne">
                  <h4 class="panel-title">
                    <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                      Importados
                    </a>
                  </h4>
                </div>
                <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body">
                    <?php echo $ok; ?>
                    </div>
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingTwo">
                  <h4 class="panel-title">
                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                      Já Importados / Duplicados
                    </a>
                  </h4>
                </div>
                <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
                  <div class="panel-body">
                        <?php echo $erro2; ?>
                  </div>
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingThree">
                  <h4 class="panel-title">
                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                      Registros com Erro nos Dados
                    </a>
                  </h4>
                </div>
                <div id="collapseThree" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingThree">
                  <div class="panel-body">
                        <?php echo $erro1; ?>
                  </div>
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingThree">
                  <h4 class="panel-title">
                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse4" aria-expanded="false" aria-controls="collapseThree">
                      Funcionários não Encontrados
                    </a>
                  </h4>
                </div>
                <div id="collapse4" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading4">
                  <div class="panel-body">
                        <?php echo $erro3; ?>
                  </div>
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading" role="tab" id="headingThree">
                  <h4 class="panel-title">
                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse5" aria-expanded="false" aria-controls="collapseThree">
                      Empresas Inativas
                    </a>
                  </h4>
                </div>
                <div id="collapse5" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading4">
                  <div class="panel-body">
                        <?php echo $erro4; ?>
                  </div>
                </div>
            </div>
        </div>

            <?php

        } else {

            $handle = fopen($_FILES['arquivo']['tmp_name'], "r");
            $cargo_id = $_POST["cargo_id"];
            if ( empty ( $cargo_id ) ) {
                 echo "<div class='alert alert-danger'>Selecione o Cargo/Empresa</div>";
            } else {
                $i = 0;
                while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
                   if ( $i > 0) {
                       if ( !empty ($data[0] ) ) {
                            $nome = $data[0];
                            $cidade = utf8_encode($data[1]);
                            $email = $data[2];
                            $login = strtolower($nome);

                            $tipo = "Normal";

                            $sql = "select * from funcionario where login = ? and email = ? limit 1";
                            $consulta = $db->prepare($sql);
                            $consulta->bindParam(1, $login);
                            $consulta->bindParam(2, $email);
                            $consulta->execute();

                            $dados = $consulta->fetch(PDO::FETCH_OBJ);
                            $senha = md5($login);
                            $telefone = "NULL";

                            if ( empty( $dados->id ) ) {
                                $sql = "insert into funcionario (id,nome,cargo_id,tipo,email,login,senha,cidade) values (NULL,?,?,?,?,?,?,?)";
                                $consulta = $db->prepare($sql);
                                $consulta->bindParam(1, $nome);
                                $consulta->bindParam(2, $cargo_id);
                                $consulta->bindParam(3, $tipo);
                                $consulta->bindParam(4, $email);
                                $consulta->bindParam(5, $login);
                                $consulta->bindParam(6, $senha);
                                $consulta->bindParam(7, $cidade);
                                if ( $consulta->execute() ) {
                                    echo "<p class='alert alert-success'><strong>Cadastro OK:</strong> e-mail $login cadastrado!</p>";
                                } else {
                                    echo "<p class='alert alert-danger'><strong>Erro:</strong> erro ao inserir $login ".$consulta->errorInfo()[2]."  !</p>";
                                }
                            } else {
                                echo "<p class='alert alert-warning'><strong>Erro:</strong> e-mail $email já cadastrado!</p>";
                            }
                       }
                   }
                   $i++;

                }
            }
            

        }

    }
?>
</div>

<!-- Nav tabs -->
  <ul class="nav nav-tabs" role="tablist">
    <li role="presentation" class="active"><a href="#consultores" aria-controls="consultores" role="tab" data-toggle="tab">Importar Consultores</a></li>
    <li role="presentation"><a href="#pagamento" aria-controls="pagamento" role="tab" data-toggle="tab">Importar Arquivo de Pagamento</a></li>
   
  </ul>





  <!-- Tab panes -->
  <div class="tab-content">
    <div role="tabpanel" class="tab-pane active" id="consultores">
        <h2>Importar Consultores</h2>
        <form name="form1" method="post" enctype="multipart/form-data" class="form-inline">
            <input type="hidden" name="tipo" value="consultores">
            <label for="arquivo">Selecione o arquivo (CSV separado por vírgula):
            <input type="file" name="arquivo" class="form-control" required></label>
            <label for="cargo_id">Cargo/Empresa
            <select name="cargo_id" class="form-control" required>
                <option value=""></option>
                <?php
                    $sql = "select * from cargo order by cargo";
                    $consulta = $db->prepare($sql);
                    $consulta->execute();

                    while ( $dados = $consulta->fetch(PDO::FETCH_OBJ) ) {
                        echo "<option value='$dados->id'>$dados->cargo</option>";
                    }
                ?>
            </select>
            <button type="submit" class="btn btn-success">
                <i class="glyphicon glyphicon-ok"></i> Importar
            </button>
        </form>
    </div>
    <div role="tabpanel" class="tab-pane" id="pagamento">
        <h2>Importar Planilha de Pagamento</h2>
        <form name="form1" method="post" enctype="multipart/form-data" class="form-inline">
            <input type="hidden" name="tipo" value="pagamento">
            <label for="arquivo">Selecione o arquivo (CSV separado por vírgula):
            <input type="file" name="arquivo" class="form-control" required></label>
            <button type="submit" class="btn btn-success">
                <i class="glyphicon glyphicon-ok"></i> Importar
            </button>
        </form>
    </div>
    
  </div>
  <div style="margin-top: 200px;"></div>
</div>


<div class="clearfix"></div>