<?php
	session_start();
	$param = "download";
	include "config.php";
	include "pages/acesso.php";

	$id = "";
	if ( isset ( $_GET["id"] ) ) $id = $_GET["id"];

	$sql = "select * from arquivo where id = ? and cliente_id = ? limit 1";
	$consulta = $db->prepare($sql);
	$consulta->bindParam(1, $id);
	$consulta->bindParam(2, $_SESSION["max"]["id"]);
	$consulta->execute();

	$dados = $consulta->fetch(PDO::FETCH_OBJ);

	if ( empty ( $dados->id ) ) {

		echo "<div class='alert alert-danger'><strong>ERRO:</strong> arquivo inválido ou não localizado. Entre em contato com a MaxCredit.</div>";

	} else {

		$aquivoNome = "../downloads/$dados->arquivo";

		if ( file_exists ( $aquivoNome) ) {

			// Configuramos os headers que serão enviados para o browser
			header('Content-Description: File Transfer');
			header('Content-Disposition: attachment; filename="BOLETO_'.$dados->cliente_id.'.pdf"');
			header('Content-Type: application/octet-stream');
			header('Content-Transfer-Encoding: binary');
			header('Content-Length: ' . filesize($aquivoNome));
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Pragma: public');
			header('Expires: 0');
			// Envia o arquivo para o cliente
			readfile($aquivoNome);

		} else {

			echo "<div class='alert alert-danger'><strong>ERRO:</strong> arquivo não localizado. Entre em contato com a MaxCredit.</div>";

		}

	}

	